﻿#include "precompiled.h"
#include "common.h"
#include "Mesh.h"

namespace RTCam {

Mesh::Mesh(_In_z_ const char* name) :
	Resource(name),
	m_indexCount(0),
	m_vertexBuffer(nullptr),
	m_indexBuffer(nullptr)
{
}


Mesh::~Mesh(void)
{
}

void Mesh::Initialize(_In_ ID3D11Device1* d3dDevice, DirectX::VertexPositionNormalColor vertices[], size_t numVertices, uint16_t indices[], size_t numIndices)
{
	m_indexCount = numIndices;

	// Create vertex buffer
	D3D11_SUBRESOURCE_DATA vertexBufferData = {0};
	vertexBufferData.pSysMem = vertices;
	vertexBufferData.SysMemPitch = 0;
	vertexBufferData.SysMemSlicePitch = 0;
	CD3D11_BUFFER_DESC vertexBufferDesc(sizeof(vertices[0]) * numVertices, D3D11_BIND_VERTEX_BUFFER);
	ThrowIfFailed(
		d3dDevice->CreateBuffer(
		&vertexBufferDesc,
		&vertexBufferData,
		&m_vertexBuffer
		)
		);
	SetDebugObjectName(m_vertexBuffer.Get(), m_name + " Vertex Buffer");

	// Create the index buffer
	D3D11_SUBRESOURCE_DATA indexBufferData = {0};
	indexBufferData.pSysMem = indices;
	indexBufferData.SysMemPitch = 0;
	indexBufferData.SysMemSlicePitch = 0;
	CD3D11_BUFFER_DESC indexBufferDesc(sizeof(indices[0]) * numIndices, D3D11_BIND_INDEX_BUFFER);
	ThrowIfFailed(
		d3dDevice->CreateBuffer(
		&indexBufferDesc,
		&indexBufferData,
		&m_indexBuffer
		)
		);
	SetDebugObjectName(m_indexBuffer.Get(), m_name + " Index Buffer");
}

} // end namespace